#!/bin/csh -f
# bim_plot.csh
# main driver script to generate plots from processed experimental data
# set base directory here
set base = /home/lac/setubal/netflow/andrew/unit/UFBM-98-03-06
# set programs
set progs = (bim_dfs bim_bfs bim_lds bim_ar bim_fifo bim_lo bim_hi)
#set families
#set fams =  (HiLo fewg manyg Grid Hexa Rope Zipf)
set fams =  (HiLo)
# results directory is a command-line parameter
set results = $1
# set scripts directory here
set scripts = Scripts
cd $base/$results
echo "Moving to directory " $base/$results
foreach family ($fams)
   gawk -f genplot.awk family=$family dummy >! $family.plot
   gnuplot $family.plot
end
#
