#!/bin/csh -f
# table.csh
# main driver script to prepare tables from raw experimental data
# set base directory here
set base = /home/lac/setubal/netflow/andrew/unit/UFBM-98-03-06
# set programs
set progs = (bim_dfs bim_bfs bim_lds bim_ar bim_fifo bim_lo bim_hi)
#set families
set fams =  (HiLo fewg manyg Grid Hexa Rope Zipf)
# results directory is a command-line parameter
set results = $1
# set scripts directory here
set scripts = Scripts
cd $base/$results
echo "Moving to directory " $base/$results
foreach family ($fams)
   foreach program ($progs)
       echo "crunching results from $program"
       echo $program >> temp
       gawk -f $base/$scripts/crunch.awk $program.$family >> temp
   end
   echo "prettyprinting results for $family"
   echo "%% results for $family" > $family.tex
   gawk -f $base/$scripts/pp3.awk latex=1 family=$family temp >> $family.tex
   rm temp
end
#
