#!/bin/csh -f
# table.csh
# main driver script to prepare tables from raw experimental data
# set base directory here
set base = /home/lac/setubal/netflow/andrew/unit/UFBM-98-03-06/
# set programs
set progs = (uf_dfs uf_bfs uf_lds uf_ar uf_fifo uf_lo uf_hi)
#set families
set fams =  (Karz rmfuL rmfuW rmfuC Blow Qasq Puff Saus Squa Wave)
# results directory is a command-line parameter
set results = $1
# set scripts directory here
set scripts = Scripts
cd $base/$results
echo "Moving to directory " $base/$results
foreach family ($fams)
   foreach program ($progs)
       echo "crunching results from $program"
       echo $program >> temp
       gawk -f $base/$scripts/crunch.awk $program.$family >> temp
   end
   echo "prettyprinting results for $family"
   echo "%% results for $family" > $family.tex
   gawk -f $base/$scripts/pp3.awk latex=1 family=$family temp >> $family.tex
   rm temp
end
#
